#
# Copyright (c) 2006 Mellanox Technologies. All rights reserved.
#
# This Software is licensed under one of the following licenses:
#
# 1) under the terms of the "Common Public License 1.0" a copy of which is
#    available from the Open Source Initiative, see
#    http://www.opensource.org/licenses/cpl.php.
#
# 2) under the terms of the "The BSD License" a copy of which is
#    available from the Open Source Initiative, see
#    http://www.opensource.org/licenses/bsd-license.php.
#
# 3) under the terms of the "GNU General Public License (GPL) Version 2" a
#    copy of which is available from the Open Source Initiative, see
#    http://www.opensource.org/licenses/gpl-license.php.
#
# Licensee has the right to choose one of the above licenses.
#
# Redistributions of source code must retain the above copyright
# notice and one of the license notices.
#
# Redistributions in binary form must reproduce both the above copyright
# notice, one of the license notices in the documentation
# and/or other materials provided with the distribution.
#
# $Id: openib.spec 9120 2006-08-28 13:01:07Z vlad $
#

%{!?configure_options: %define configure_options %{nil}}
%{!?configure_options32: %define configure_options32 %{nil}}
# %{!?_prefix: %define _prefix /usr/local}
%{!?_prefix: %define _prefix /usr/local/ofed}

%ifarch %{ix86} ia64 ppc
%{!?_libdir: %define _libdir %{_prefix}/lib}
%else
%{!?_libdir: %define _libdir %{_prefix}/lib64}
%endif

%{!?build_32bit: %define build_32bit 0}
%{!?_libdir32: %define _libdir32 %{_prefix}/lib}
%{!?_libdir64: %define _libdir64 %{_prefix}/lib64}

# %{!?MEMTRACK: %define MEMTRACK 0}
%define MEMTRACK %(if ( echo %{configure_options} | grep "with-memtrack" > /dev/null ); then echo -n '1'; else echo -n '0'; fi)
%define MADEYE %(if ( echo %{configure_options} | grep "with-madeye-mod" > /dev/null ); then echo -n '1'; else echo -n '0'; fi)

%{!?KVERSION: %define KVERSION %(uname -r)}
%define krelver %(echo -n %{KVERSION} | sed -e 's/-/_/g')

%{!?modprobe_update: %define modprobe_update 1}

%{!?build_kernel_ib: %define build_kernel_ib 0}
%{!?build_kernel_ib_devel: %define build_kernel_ib_devel 0}

# Select packages to build
%{!?include_ipoib_conf: %define include_ipoib_conf 1}

%{!?CFLAGS: %define CFLAGS '-g -O2'}
%{!?CXXFLAGS: %define CXXFLAGS '-g -O2'}
%{!?LDFLAGS: %define LDFLAGS '-g -O2'}
%{!?FFLAGS: %define FFLAGS '-g -O2'}
%{!?flags32: %define flags32 '-m32 -g -O2'}
%{!?ldflags32: %define ldflags32 '-m32 -g -O2 -L/usr/lib'}
%{!?flags_ppc64: %define flags_ppc64 '-m64 -g -O2'}
%{!?ldflags_ppc64: %define ldflags_ppc64 '-m64 -g -O2 -L/usr/lib64'}

# Kernel module packages to be included into kernel-ib
%define build_mthca %(if ( echo %{configure_options} | grep "with-mthca-mod" > /dev/null ); then echo -n '1'; else echo -n '0'; fi)
%define build_ipath %(if ( echo %{configure_options} | grep "with-ipath_inf-mod" > /dev/null ); then echo -n '1'; else echo -n '0'; fi)
%define build_ehca %(if ( echo %{configure_options} | grep "with-ehca-mod" > /dev/null ); then echo -n '1'; else echo -n '0'; fi)
%define build_ipoib %(if ( echo %{configure_options} | grep "with-ipoib-mod" > /dev/null ); then echo -n '1'; else echo -n '0'; fi)
%define build_sdp %(if ( echo %{configure_options} | grep "with-sdp-mod" > /dev/null ); then echo -n '1'; else echo -n '0'; fi)
%define build_srp %(if ( echo %{configure_options} | grep "with-srp-mod" > /dev/null ); then echo -n '1'; else echo -n '0'; fi)
%define build_iser %(if ( echo %{configure_options} | grep "with-iser-mod" > /dev/null ); then echo -n '1'; else echo -n '0'; fi)
%define build_rds %(if ( echo %{configure_options} | grep "with-rds-mod" > /dev/null ); then echo -n '1'; else echo -n '0'; fi)

%define build_srptools %(if ( echo "%{configure_options}" | grep -E "with-srptools|with-all-libs" > /dev/null ); then echo -n '1'; else echo -n '0'; fi)
%define build_ipoibtools %(if ( echo "%{configure_options}" | grep -E "with-ipoibtools|with-all-libs" > /dev/null ); then echo -n '1'; else echo -n '0'; fi)
%define build_tvflash %(if ( echo "%{configure_options}  %{configure_options32}" | grep -E "with-tvflash" > /dev/null ); then echo -n '1'; else echo -n '0'; fi)
%define build_libsdp %(if ( echo "%{configure_options}" | grep -E "with-libsdp|with-all-libs" > /dev/null ); then echo -n '1'; else echo -n '0'; fi)

%define build_opensm %(if ( echo "%{configure_options}" | grep -E "with-opensm|with-all-libs" > /dev/null ); then echo -n '1'; else echo -n '0'; fi)
%define build_libopensm %{build_opensm}
%define build_libopensm_devel %{build_opensm}
%define build_libosmcomp %{build_opensm}
%define build_libosmcomp_devel %{build_opensm}
%define build_libosmvendor %{build_opensm}
%define build_libosmvendor_devel %{build_opensm}

%define build_diags %(if ( echo "%{configure_options}" | grep -E "with-openib-diags|with-all-libs" > /dev/null ); then echo -n '1'; else echo -n '0'; fi)

%define build_perftest %(if ( echo "%{configure_options}" | grep -E "with-perftest|with-all-libs" > /dev/null ); then echo -n '1'; else echo -n '0'; fi)
%define build_mstflint %(if ( echo "%{configure_options} %{configure_options32}" | grep -E "with-mstflint|with-all-libs" > /dev/null ); then echo -n '1'; else echo -n '0'; fi)

%define build_libibverbs %(if ( echo "%{configure_options}" | grep -E "with-libibverbs|with-all-libs" > /dev/null ); then echo -n '1'; else echo -n '0'; fi)
%define build_libibverbs_devel %{build_libibverbs}
%define build_libibverbs_utils %{build_libibverbs}

%define build_libmthca %(if ( echo "%{configure_options}" | grep -E "with-libmthca|with-all-libs" > /dev/null ); then echo -n '1'; else echo -n '0'; fi)
%define build_libmthca_devel %{build_libmthca}

%define build_libehca %(if ( echo "%{configure_options}" | grep -E "with-libehca|with-all-libs" > /dev/null ); then echo -n '1'; else echo -n '0'; fi)
%define build_libehca_devel %{build_libehca}

%define build_libipathverbs %(if ( echo "%{configure_options}" | grep -E "with-libipathverbs|with-all-libs" > /dev/null ); then echo -n '1'; else echo -n '0'; fi)
%define build_libipathverbs_devel %{build_libipathverbs}

%define build_libibcm %(if ( echo "%{configure_options}" | grep -E "with-libibcm|with-all-libs" > /dev/null ); then echo -n '1'; else echo -n '0'; fi)
%define build_libibcm_devel %{build_libibcm}

%define build_libibcommon %(if ( echo "%{configure_options}" | grep -E "with-libibcommon|with-all-libs" > /dev/null ); then echo -n '1'; else echo -n '0'; fi)
%define build_libibcommon_devel %{build_libibcommon}

%define build_libibmad %(if ( echo "%{configure_options}" | grep -E "with-libibmad|with-all-libs" > /dev/null ); then echo -n '1'; else echo -n '0'; fi)
%define build_libibmad_devel %{build_libibmad}

%define build_libibumad %(if ( echo "%{configure_options}" | grep -E "with-libibumad|with-all-libs" > /dev/null ); then echo -n '1'; else echo -n '0'; fi)
%define build_libibumad_devel %{build_libibumad}

%define build_librdmacm %(if ( echo "%{configure_options}" | grep -E "with-librdmacm|with-all-libs" > /dev/null ); then echo -n '1'; else echo -n '0'; fi)
%define build_librdmacm_devel %{build_librdmacm}
%define build_librdmacm_utils %{build_librdmacm}

%define build_dapl %(if ( echo "%{configure_options}" | grep -E "with-dapl|with-all-libs" > /dev/null ); then echo -n '1'; else echo -n '0'; fi)
%define build_dapl_devel %{build_dapl}

%define LIB_MOD_DIR /lib/modules/%{KVERSION}/kernel/drivers/infiniband
%{!?NETWORK_CONF_DIR: %define NETWORK_CONF_DIR /etc/infiniband}


%define IB_CONF_DIR /etc/infiniband

%define K_SRC /lib/modules/%{KVERSION}/build
%{!?KSRC: %define KSRC %{K_SRC}}

%{!?KERNEL_SOURCES: %define KERNEL_SOURCES /lib/modules/%{KVERSION}/source}

# Do not include srp.h if it exist in the kernel
%define include_srp_h %(if [ -e %{KERNEL_SOURCES}/include/scsi/srp.h ]; then echo -n 0; else echo -n 1; fi )
%define include_rdma %(if [ -d %{KERNEL_SOURCES}/include/rdma ]; then echo -n 1; else echo -n 0; fi )

%define include_udev_rules %(eval `grep udev_rules /etc/udev/udev.conf | grep -v '^#'` ; if test -d $udev_rules; then echo -n 1; else echo -n 0; fi)

# Disable debugging
%define debug_package %{nil}
%define __check_files %{nil}

# Disable brp-lib64-linux
%ifarch x86_64 ia64
%define __arch_install_post %{nil}
%endif

%define librdmacm_ver 0.9.0
%define libibcm_ver 0.9.0

%{!?_name: %define _name openib}
%{!?_version: %define _version 1.1}
%{!?_release: %define _release 0}

Summary: Infiniband HCA Driver
Prereq: /sbin/ldconfig
Name: %{_name}
Version: %{_version}
Release: %{_release}
License: GPL/BSD
Url: http://openib.org/
Group: System Environment/Base
Source: %{_name}-%{_version}.tgz
BuildRoot: %{?build_root:%{build_root}}%{!?build_root:/var/tmp/OFED}
Vendor: OpenFabrics
%description 
InfiniBand "verbs", Access Layer  and ULPs

BuildRequires: sysfsutils-devel

%package -n kernel-ib
Version: %{_version}
Release: %{krelver}
Summary: Infiniband Driver and ULPs kernel modules
Group: System Environment/Libraries
%description -n kernel-ib
Core, HW and ULPs kernel modules

%package -n kernel-ib-devel
Version: %{_version}
Release: %{krelver}
Summary: Infiniband Driver and ULPs kernel modules sources
Group: System Environment/Libraries
%description -n kernel-ib-devel
Core, HW and ULPs kernel modules sources

%package -n libibverbs
Version: 1.0.4
Release: 0
Summary: A library for direct userspace use of InfiniBand
Group: System Environment/Libraries
%description -n libibverbs
libibverbs is a library that allows userspace processes to use
InfiniBand "verbs" as described in the InfiniBand Architecture
Specification.  This includes direct hardware access for fast path
operations.

%package -n libibverbs-devel
Version: 1.0.4
Release: 0
Summary: Development files for the libibverbs library
Group: System Environment/Libraries
%description -n libibverbs-devel
Static libraries and header files for the libibverbs verbs library.

%package -n libibverbs-utils
Version: 1.0.4
Release: 0
Summary: Examples for the libibverbs library
Group: System Environment/Libraries
%description -n libibverbs-utils
Useful libibverbs1 example programs such as ibv_devinfo, which
displays information about InfiniBand devices.

%package -n libibcm
Version: 0.9.0
Release: 0
Summary: Userspace InfiniBand Connection Manager.
Group: System Environment/Libraries
%description -n libibcm
Along with the OpenIB kernel drivers, libibcm provides a userspace
InfiniBand Connection Managment API.

%package -n libibcm-devel
Version: 0.9.0
Release: 0
Summary: Development files for the libibcm library
Group: System Environment/Libraries
%description -n libibcm-devel
Development files for the libibcm library.

%package -n libmthca
Version: 1.0.3
Release: 0
Summary: Mellanox InfiniBand HCA Userspace Driver
Group: System Environment/Libraries
%description -n libmthca
libmthca provides a device-specific userspace driver for Mellanox HCAs
(MT23108 InfiniHost and MT25208 InfiniHost III Ex) for use with the
libibverbs library.

%package -n libmthca-devel
Version: 1.0.3
Release: 0
Summary: Development files for the libmthca driver
Group: System Environment/Libraries
%description -n libmthca-devel
Static version of libmthca that may be linked directly to an
application, which may be useful for debugging.

%package -n libipathverbs
Version: 1.0
Release: 0
Summary: PathScale InfiniPath HCA Userspace Driver
Group: System Environment/Libraries
%description -n libipathverbs
libipathverbs provides a device-specific userspace driver for PathScale HCAs.

%package -n libipathverbs-devel
Version: 1.0
Release: 0
Summary: Development files for the libipathverbs driver
Group: System Environment/Libraries
%description -n libipathverbs-devel
Static version of libipathverbs that may be linked directly to an
application, which may be useful for debugging.

%package -n libehca
Version: 1.0
Release: 0
Summary: IBM eServer eHCA Infiniband device driver for Linux on POWER
Group: System Environment/Libraries
%description -n libehca
IBM eServer eHCA Infiniband device driver for Linux on POWER

%package -n libehca-devel
Version: 1.0
Release: 0
Summary: Development files for the libehca driver
Group: System Environment/Libraries
%description -n libehca-devel
Static version of libehca that may be linked directly to an
application, which may be useful for debugging.

%package -n libsdp
Version: 1.1.0
Release: 0
Summary: LD_PRELOAD-able library for using SDP
Group: System Environment/Libraries
%description -n libsdp
libsdp can be LD_PRELOAD-ed to have a sockets application use
InfiniBand Sockets Direct Protocol (SDP) instead of TCP, transparently
and without recompiling the application.

%package -n srptools
Version: 0.0.4
Release: 0
Summary: Tools for SRP/IB
Group: Applications/System
%description -n srptools
In conjunction with the kernel ib_srp driver, srptools allows you to
discover and use SCSI devices via the SCSI RDMA Protocol over InfiniBand.

%package -n ipoibtools
Version: 1.0
Release: 0
Summary: IPoIB High Availability daemon
Group: Applications/System
%description -n ipoibtools
IPoIB High Availability daemon

%package -n tvflash
Version: 0.9.0
Release: 0
Summary: Tool to manage Mellanox HCA firmware flash memory
Group: Applications/System
%description -n tvflash
tvflash is used to query and update the firmware flash memory attached
to Mellanox InfiniBand HCAs.

%package -n libibcommon
Version: 1.0
Release: 0
Summary: OpenIB InfiniBand Management and Diagnostic Tools
Group: System Environment/Libraries
%description -n libibcommon
libibcommon provides common utility functions for the IB diagnostic and
management tools.

%package -n libibcommon-devel
Version: 1.0
Release: 0
Summary: Development files for the libibcommon library
Group: System Environment/Libraries
%description -n libibcommon-devel
Development files for the libibcommon library

%package -n libibmad
Version: 1.0
Release: 0
Summary: OpenIB InfiniBand Management and Diagnostic Tools
Group: System Environment/Libraries
%description -n libibmad
libibmad provides low layer IB functions for use by the IB diagnostic
and management programs. These include MAD, SA, SMP, and other basic
IB functions.

%package -n libibmad-devel
Version: 1.0
Release: 0
Summary: Development files for the libibmad library.
Group: System Environment/Libraries
%description -n libibmad-devel
Development files for the libibmad library.

%package -n libibumad
Version: 1.0
Release: 0
Summary: OpenIB InfiniBand Management and Diagnostic Tools
Group: System Environment/Libraries
%description -n libibumad
libibumad provides the user MAD library functions which sit on top of
the user MAD modules in the kernel. These are used by the IB diagnostic
and management tools, including OpenSM.

%package -n libibumad-devel
Version: 1.0
Release: 0
Summary: Development files for the libibumad library.
Group: System Environment/Libraries
%description -n libibumad-devel
Development files for the libibumad library.

%package -n openib-diags
Version: 1.1.0
Release: 0
Summary: OpenIB InfiniBand Diagnostic Tools
Group: System Environment/Libraries
%description -n openib-diags
diags provides IB diagnostic programs and scripts needed to diagnose
an IB subnet.

%package -n libosmcomp
Version: 2.0.0
Release: 0
Summary: OpenSM component library
Group: System Environment/Libraries
%description -n libosmcomp
libosmcomp provides the OS component library for OpenSM.

%package -n libosmcomp-devel
Version: 2.0.0
Release: 0
Summary: Development files for OpenSM
Group: System Environment/Libraries
%description -n libosmcomp-devel
Static component libraries for OpenSM.

%package -n libopensm
Version: 2.0.0
Release: 0
Summary: OpenSM libraries
Group: System Environment/Libraries
%description -n libopensm
libopensm provides the library for OpenSM.

%package -n libopensm-devel
Version: 2.0.0
Release: 0
Summary: Development files for OpenSM
Group: System Environment/Libraries
%description -n libopensm-devel
Static component libraries for OpenSM.

%package -n libosmvendor
Version: 2.0.0
Release: 0
Summary: OpenSM vendor library
Group: System Environment/Libraries
%description -n libosmvendor
libosmvendor provides the vendor library for OpenSM.

%package -n libosmvendor-devel
Version: 2.0.0
Release: 0
Summary: Development files for OpenSM
Group: System Environment/Libraries
%description -n libosmvendor-devel
Static vendor libraries for OpenSM.

%package -n opensm
Version: 2.0.0
Release: 0
Summary: InfiniBand subnet manager and administration
Group: System Environment/Libraries
%description -n opensm
OpenSM provides an implementation for an InfiniBand Subnet Manager and
Administration. Such a software entity is required to run for in order
to initialize the InfiniBand hardware (at least one per each
InfiniBand subnet).

%package -n perftest
Version: 1.0
Release: 0
Summary: IB Performance tests
Group: System Environment/Libraries
%description -n perftest
gen2 uverbs microbenchmarks

%package -n mstflint
Version: 1.0
Release: 0
Summary: Burning Firmware Application
Group:  Applications/System
%description -n mstflint
This package contains a burning tool for Mellanox manufactured HCA cards.
It also provides access to the relevant source code.

%package -n librdmacm
Version: 0.9.0
Release: 0
Summary: RDMA cm library.
Group:  System Environment/Libraries
%description -n librdmacm
RDMA cm library.

%package -n librdmacm-devel
Version: 0.9.0
Release: 0
Summary: Development files for the librdmacm library
Group:  System Environment/Libraries
%description -n librdmacm-devel
Development files for the librdmacm library.

%package -n librdmacm-utils
Version: 0.9.0
Release: 0
Summary: Utilities for the librdmacm library
Group:  System Environment/Base
%description -n librdmacm-utils
Utilities for the librdmacm library.

%package -n dapl
Version: 1.2.0
Release: 0
Summary: Userspace DAT and DAPL API.
Group:  System Environment/Libraries
%description -n dapl
Along with the OpenIB kernel drivers, libdat and libdapl provides a userspace
RDMA API that supports DAT 1.2 specification

%package -n dapl-devel
Version: 1.2.0
Release: 0
Summary: Development files for the libdat and libdapl libraries
Group:  System Environment/Libraries
%description -n dapl-devel
Static libraries and header files for the libdat and libdapl library.


#################################################################################################################################


%prep
%setup -n %{_name}-%{_version}

###
### install
###
%install
rm -rf $RPM_BUILD_ROOT
	
cd $RPM_BUILD_DIR/%{_name}-%{_version}

# Save clean sources
mkdir -p $RPM_BUILD_ROOT/%{_prefix}/src
cp -a $RPM_BUILD_DIR/%{_name}-%{_version} $RPM_BUILD_ROOT/%{_prefix}/src

# ./install.sh --batch --build_only --prefix %{_prefix} --tmpdir $RPM_BUILD_ROOT/%{TMPDIR} -kver %{KVERSION} --ksrc %{KSRC} --packages %{PACKAGES} -- %{WITH_UL_PACKAGES} --build_root $RPM_BUILD_ROOT ${INSTALL_PARAMS}

%ifarch ppc64
env CFLAGS=%{flags_ppc64} CXXFLAGS=%{flags_ppc64} LDFLAGS=%{ldflags_ppc64} FFLAGS=%{flags_ppc64} \
./configure --prefix=%{_prefix} --libdir=%{_libdir64} --kernel-version %{KVERSION} --kernel-sources %{KSRC} %{configure_options}
%else
./configure --prefix=%{_prefix} --libdir=%{_libdir} --kernel-version %{KVERSION} --kernel-sources %{KSRC} %{configure_options}
%endif

# Copy InfniBand include files after applying backport patches (if required)
mkdir -p $RPM_BUILD_ROOT/%{_prefix}/src/%{_name}/drivers/infiniband
cp -a $RPM_BUILD_DIR/%{_name}-%{_version}/drivers/infiniband/include/ $RPM_BUILD_ROOT/%{_prefix}/src/%{_name}
cp -a $RPM_BUILD_DIR/%{_name}-%{_version}/configure.mk $RPM_BUILD_ROOT/%{_prefix}/src/%{_name}

# Create drivers/infiniband/include link
pushd $RPM_BUILD_ROOT/%{_prefix}/src/%{_name}/drivers/infiniband
ln -s ../../include
popd

%if %{build_kernel_ib}
make kernel
make copy_kernel MODULES_DIR=/lib/modules/%{KVERSION} DESTDIR=$RPM_BUILD_ROOT
%endif

%ifarch ppc64
    %if %{build_perftest}
        make perftest LDLIBS='-m64 -g -O2 -L/usr/lib64'
    %endif
    make user WITH_PERFTEST=no
%else
    make user
%endif
make DESTDIR=$RPM_BUILD_ROOT install_user

%ifarch x86_64 ppc64
    %if %{build_32bit}
        # Backup 64 bit binaries
        if [ -d $RPM_BUILD_ROOT%{_prefix}/bin ]; then
            mv $RPM_BUILD_ROOT%{_prefix}/bin $RPM_BUILD_ROOT%{_prefix}/bin64
        fi
        if [ -d $RPM_BUILD_ROOT%{_prefix}/sbin ]; then
            mv $RPM_BUILD_ROOT%{_prefix}/sbin $RPM_BUILD_ROOT%{_prefix}/sbin64
        fi
        # dirs=$(find $RPM_BUILD_DIR/%{_name}-%{_version}/src/userspace  -maxdepth 2 -name Makefile -exec dirname '{}' ';')
        dirs=$(find $RPM_BUILD_DIR/%{_name}-%{_version}/src/userspace -name Makefile -exec dirname '{}' ';')
        for dd in $dirs; do if ! ( make clean -C $dd ); then continue; fi; done
        env CFLAGS=%{flags32} CXXFLAGS=%{flags32} LDFLAGS=%{ldflags32} FFLAGS=%{flags32} \
        ./configure --prefix=%{_prefix} --libdir=%{_libdir32} --without-patch %{configure_options32}
        make user
        make DESTDIR=$RPM_BUILD_ROOT install_user
        # Backup 32 bit binaries
        if [ -d $RPM_BUILD_ROOT%{_prefix}/bin ]; then
            mv $RPM_BUILD_ROOT%{_prefix}/bin $RPM_BUILD_ROOT%{_prefix}/bin32
        fi
        if [ -d $RPM_BUILD_ROOT%{_prefix}/sbin ]; then
            mv $RPM_BUILD_ROOT%{_prefix}/sbin $RPM_BUILD_ROOT%{_prefix}/sbin32
        fi
        # Restore 64 bit binaries
        if [ -d $RPM_BUILD_ROOT%{_prefix}/bin64 ]; then
            mv $RPM_BUILD_ROOT%{_prefix}/bin64 $RPM_BUILD_ROOT%{_prefix}/bin
        fi
        if [ -d $RPM_BUILD_ROOT%{_prefix}/sbin64 ]; then
            mv $RPM_BUILD_ROOT%{_prefix}/sbin64 $RPM_BUILD_ROOT%{_prefix}/sbin
        fi
        if [ -f $RPM_BUILD_ROOT%{_prefix}/sbin32/tvflash ] && [ ! -f $RPM_BUILD_ROOT%{_prefix}/sbin/tvflash ]; then
            mkdir -p $RPM_BUILD_ROOT%{_prefix}/sbin
            install -m 0755 $RPM_BUILD_ROOT%{_prefix}/sbin32/tvflash $RPM_BUILD_ROOT%{_prefix}/sbin/tvflash
        fi
        if [ -f $RPM_BUILD_ROOT%{_prefix}/bin32/mstflint ] && [ ! -f $RPM_BUILD_ROOT%{_prefix}/bin/mstflint ]; then
            install -m 0755 $RPM_BUILD_ROOT%{_prefix}/bin32/mstflint $RPM_BUILD_ROOT%{_prefix}/bin
            install -m 0755 $RPM_BUILD_ROOT%{_prefix}/bin32/mread $RPM_BUILD_ROOT%{_prefix}/bin
            install -m 0755 $RPM_BUILD_ROOT%{_prefix}/bin32/mwrite $RPM_BUILD_ROOT%{_prefix}/bin
        fi
    %else # Build libsdp 32 bit in any case
        %if %{build_libsdp}
            make -C src/userspace/libsdp clean
            env CFLAGS=%{flags32} CXXFLAGS=%{flags32} LDFLAGS=%{flags32} FFLAGS=%{flags32} \
            ./configure --prefix=%{_prefix} --libdir=%{_libdir32} --without-patch --with-libsdp 
            make libsdp
            make DESTDIR=$RPM_BUILD_ROOT install_libsdp
        %endif
    %endif
%endif
	
################################## Handle kernel modules ##################################

    # Fix kernel modules path in case that modules were installed under 'extra' directory
    install -d $RPM_BUILD_ROOT/%{_prefix}/include
    install -d $RPM_BUILD_ROOT/%{_prefix}/etc
    install -d $RPM_BUILD_ROOT%{LIB_MOD_DIR}/core
    install -d $RPM_BUILD_ROOT%{LIB_MOD_DIR}/debug
    install -d $RPM_BUILD_ROOT%{LIB_MOD_DIR}/util
    install -d $RPM_BUILD_ROOT%{LIB_MOD_DIR}/hw/mthca
    install -d $RPM_BUILD_ROOT%{LIB_MOD_DIR}/hw/ipath
    install -d $RPM_BUILD_ROOT%{LIB_MOD_DIR}/hw/ehca
    install -d $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ulp
    install -d $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ulp/ipoib
    install -d $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ulp/sdp
    install -d $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ulp/srp
    install -d $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ulp/iser
    install -d $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ulp/rds
    
    
    # Core modules	
    test -e $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_addr.ko && mv $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_addr.ko $RPM_BUILD_ROOT%{LIB_MOD_DIR}/core
    test -e $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_at.ko && mv $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_at.ko $RPM_BUILD_ROOT%{LIB_MOD_DIR}/core
    test -e $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_cm.ko && mv $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_cm.ko $RPM_BUILD_ROOT%{LIB_MOD_DIR}/core
    test -e $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_core.ko && mv $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_core.ko $RPM_BUILD_ROOT%{LIB_MOD_DIR}/core
    test -e $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_mad.ko && mv $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_mad.ko $RPM_BUILD_ROOT%{LIB_MOD_DIR}/core
    test -e $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_ping.ko && mv $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_ping.ko $RPM_BUILD_ROOT%{LIB_MOD_DIR}/core
    test -e $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_sa.ko && mv $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_sa.ko $RPM_BUILD_ROOT%{LIB_MOD_DIR}/core
    test -e $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_uat.ko && mv $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_uat.ko $RPM_BUILD_ROOT%{LIB_MOD_DIR}/core
    test -e $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_ucm.ko && mv $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_ucm.ko $RPM_BUILD_ROOT%{LIB_MOD_DIR}/core
    test -e $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_umad.ko && mv $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_umad.ko $RPM_BUILD_ROOT%{LIB_MOD_DIR}/core
    test -e $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_uverbs.ko && mv $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_uverbs.ko $RPM_BUILD_ROOT%{LIB_MOD_DIR}/core
    test -e $RPM_BUILD_ROOT%{LIB_MOD_DIR}/rdma_cm.ko && mv $RPM_BUILD_ROOT%{LIB_MOD_DIR}/rdma_cm.ko $RPM_BUILD_ROOT%{LIB_MOD_DIR}/core
    test -e $RPM_BUILD_ROOT%{LIB_MOD_DIR}/rdma_ucm.ko && mv $RPM_BUILD_ROOT%{LIB_MOD_DIR}/rdma_ucm.ko $RPM_BUILD_ROOT%{LIB_MOD_DIR}/core
    test -e $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_local_sa.ko && mv $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_local_sa.ko $RPM_BUILD_ROOT%{LIB_MOD_DIR}/core
    test -e $RPM_BUILD_ROOT%{LIB_MOD_DIR}/findex.ko && mv $RPM_BUILD_ROOT%{LIB_MOD_DIR}/findex.ko $RPM_BUILD_ROOT%{LIB_MOD_DIR}/core
    test -e $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_multicast.ko && mv $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_multicast.ko $RPM_BUILD_ROOT%{LIB_MOD_DIR}/core
    
    # MEMTRACK module
    test -e $RPM_BUILD_ROOT%{LIB_MOD_DIR}/memtrack.ko && mv $RPM_BUILD_ROOT%{LIB_MOD_DIR}/memtrack.ko $RPM_BUILD_ROOT%{LIB_MOD_DIR}/debug
    # MADEYE module
    test -e $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_madeye.ko && mv $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_madeye.ko $RPM_BUILD_ROOT%{LIB_MOD_DIR}/util
    
    # HW modules
    test -e $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_mthca.ko && mv $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_mthca.ko $RPM_BUILD_ROOT%{LIB_MOD_DIR}/hw/mthca
    
    test -e $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_ipath.ko && mv $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_ipath.ko $RPM_BUILD_ROOT%{LIB_MOD_DIR}/hw/ipath

    test -e $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_ehca.ko && mv $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_ehca.ko $RPM_BUILD_ROOT%{LIB_MOD_DIR}/hw/ehca
    
    # ULP modules
    test -e $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_ipoib.ko && 
        mv $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_ipoib.ko $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ulp/ipoib
    
    test -e $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_sdp.ko && 
        mv $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_sdp.ko $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ulp/sdp
    
    test -e $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_iser.ko && 
        mv $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_iser.ko $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ulp/iser
    
    test -e $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_rds.ko && 
        mv $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_rds.ko $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ulp/rds
    
    test -e $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_srp.ko && 
        mv $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ib_srp.ko $RPM_BUILD_ROOT%{LIB_MOD_DIR}/ulp/srp

################################## END Handle kernel modules ##################################

INFO=${RPM_BUILD_ROOT}%{IB_CONF_DIR}/info
/bin/rm -f ${INFO}
mkdir -p ${RPM_BUILD_ROOT}%{IB_CONF_DIR}
touch ${INFO}

cat >> ${INFO} << EOFINFO
#!/bin/bash

echo prefix=%{_prefix}
echo Kernel=%{KVERSION}
echo
echo "Configure options: %{configure_options}"
echo
EOFINFO

chmod +x ${INFO} > /dev/null 2>&1


##     # Handle 32 bit libraries
touch libsdp-files
touch libibverbs-files
touch libibverbs-devel-files
touch libibcm-files
touch libibcm-devel-files
touch librdmacm-files
touch librdmacm-devel-files
touch dapl-files
touch dapl-devel-files
touch libmthca-files
touch libmthca-devel-files
touch libipathverbs-files
touch libipathverbs-devel-files
touch libehca-files
touch libehca-devel-files
touch libibcommon-files
touch libibcommon-devel-files
touch libibmad-files
touch libibmad-devel-files
touch libibumad-files
touch libibumad-devel-files
touch libopensm-files
touch libopensm-devel-files
touch libosmcomp-files
touch libosmcomp-devel-files
touch libosmvendor-files
touch libosmvendor-devel-files


%ifarch x86_64 ppc64
    # libsdp
    # Remove 32 bit libsdp_sys libraries from 'prefix'/lib directory
    /bin/rm -f $RPM_BUILD_ROOT%{_libdir32}/libsdp_sys*so*
    if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/libsdp*so* > /dev/null 2>&1 ); then
        /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/libsdp*so* | sed -e "s@$RPM_BUILD_ROOT@@g" > libsdp-files
    fi
    %if %{build_32bit}
        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/libibverbs*so.* > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/libibverbs*so.* | sed -e "s@$RPM_BUILD_ROOT@@g" > libibverbs-files
        fi
        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/libibverbs*so > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/libibverbs*so | sed -e "s@$RPM_BUILD_ROOT@@g" > libibverbs-devel-files
        fi
        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/libibverbs*.a > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/libibverbs*.a | sed -e "s@$RPM_BUILD_ROOT@@g" >> libibverbs-devel-files
        fi

        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/libibcm*so.* > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/libibcm*so.* | sed -e "s@$RPM_BUILD_ROOT@@g" > libibcm-files
        fi
        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/libibcm*so > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/libibcm*so | sed -e "s@$RPM_BUILD_ROOT@@g" > libibcm-devel-files
        fi
        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/libibcm*.a > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/libibcm*.a | sed -e "s@$RPM_BUILD_ROOT@@g" >> libibcm-devel-files
        fi

        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/librdmacm*so.* > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/librdmacm*so.* | sed -e "s@$RPM_BUILD_ROOT@@g" > librdmacm-files
        fi
        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/librdmacm*so > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/librdmacm*so | sed -e "s@$RPM_BUILD_ROOT@@g" > librdmacm-devel-files
        fi
        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/librdmacm*.a > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/librdmacm*.a | sed -e "s@$RPM_BUILD_ROOT@@g" >> librdmacm-devel-files
        fi

        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/libda*so.* > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/libda*so.* | sed -e "s@$RPM_BUILD_ROOT@@g" > dapl-files
        fi
        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/libda*so > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/libda*so | sed -e "s@$RPM_BUILD_ROOT@@g" > dapl-devel-files
        fi
        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/libda*.a > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/libda*.a | sed -e "s@$RPM_BUILD_ROOT@@g" >> dapl-devel-files
        fi

        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/infiniband/mthca*so* > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/infiniband/mthca*so* | sed -e "s@$RPM_BUILD_ROOT@@g" > libmthca-files
        fi
        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/infiniband/mthca*.a > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/infiniband/mthca*.a | sed -e "s@$RPM_BUILD_ROOT@@g" >> libmthca-devel-files
        fi

        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/ipathverbs*so* > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/ipathverbs*so* | sed -e "s@$RPM_BUILD_ROOT@@g" > libipathverbs-files
        fi
        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/ipathverbs*.a > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/ipathverbs*.a | sed -e "s@$RPM_BUILD_ROOT@@g" >> libipathverbs-devel-files
        fi

        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/infiniband/libehca*so* > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/infiniband/libehca*so* | sed -e "s@$RPM_BUILD_ROOT@@g" > libehca-files
        fi
        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/infiniband/libehca*.a > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/infiniband/libehca*.a | sed -e "s@$RPM_BUILD_ROOT@@g" >> libehca-devel-files
        fi

        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/libibcommon*so.* > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/libibcommon*so.* | sed -e "s@$RPM_BUILD_ROOT@@g" > libibcommon-files
        fi
        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/libibcommon*so > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/libibcommon*so | sed -e "s@$RPM_BUILD_ROOT@@g" > libibcommon-devel-files
        fi
        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/libibcommon*.a > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/libibcommon*.a | sed -e "s@$RPM_BUILD_ROOT@@g" >> libibcommon-devel-files
        fi

        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/libibmad*so.* > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/libibmad*so.* | sed -e "s@$RPM_BUILD_ROOT@@g" > libibmad-files
        fi
        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/libibmad*so > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/libibmad*so | sed -e "s@$RPM_BUILD_ROOT@@g" > libibmad-devel-files
        fi
        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/libibmad*.a > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/libibmad*.a | sed -e "s@$RPM_BUILD_ROOT@@g" >> libibmad-devel-files
        fi

        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/libibumad*so.* > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/libibumad*so.* | sed -e "s@$RPM_BUILD_ROOT@@g" > libibumad-files
        fi
        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/libibumad*so > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/libibumad*so | sed -e "s@$RPM_BUILD_ROOT@@g" > libibumad-devel-files
        fi
        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/libibumad*.a > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/libibumad*.a | sed -e "s@$RPM_BUILD_ROOT@@g" >> libibumad-devel-files
        fi

        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/libopensm*so.* > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/libopensm*so.* | sed -e "s@$RPM_BUILD_ROOT@@g" > libopensm-files
        fi
        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/libopensm*so > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/libopensm*so | sed -e "s@$RPM_BUILD_ROOT@@g" > libopensm-devel-files
        fi
        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/libopensm*.a > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/libopensm*.a | sed -e "s@$RPM_BUILD_ROOT@@g" >> libopensm-devel-files
        fi

        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/libosmcomp*so.* > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/libosmcomp*so.* | sed -e "s@$RPM_BUILD_ROOT@@g" > libosmcomp-files
        fi
        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/libosmcomp*so > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/libosmcomp*so | sed -e "s@$RPM_BUILD_ROOT@@g" > libosmcomp-devel-files
        fi
        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/libosmcomp*.a > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/libosmcomp*.a | sed -e "s@$RPM_BUILD_ROOT@@g" >> libosmcomp-devel-files
        fi

        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/libosmvendor*so.* > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/libosmvendor*so.* | sed -e "s@$RPM_BUILD_ROOT@@g" > libosmvendor-files
        fi
        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/libosmvendor*so > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/libosmvendor*so | sed -e "s@$RPM_BUILD_ROOT@@g" > libosmvendor-devel-files
        fi
        if ( /bin/ls $RPM_BUILD_ROOT%{_libdir32}/libosmvendor*.a > /dev/null 2>&1 ); then
            /bin/ls -1 $RPM_BUILD_ROOT%{_libdir32}/libosmvendor*.a | sed -e "s@$RPM_BUILD_ROOT@@g" >> libosmvendor-devel-files
        fi

    %endif
%endif

%if %{build_libibcm}
    cd $RPM_BUILD_ROOT%{_libdir}
    if [ -f libibcm.so ]; then
        mv libibcm.so libibcm.so.%{libibcm_ver}
        ln -s libibcm.so.%{libibcm_ver} libibcm.so
    fi
%endif

%if %{build_librdmacm}
    cd $RPM_BUILD_ROOT%{_libdir}
    if [ -f librdmacm.so ]; then
        mv librdmacm.so librdmacm.so.%{librdmacm_ver}
        ln -s librdmacm.so.%{librdmacm_ver} librdmacm.so
    fi
%endif

# Copy infiniband configuration
install -d $RPM_BUILD_ROOT/%{IB_CONF_DIR}
install -m 0644 $RPM_BUILD_DIR/%{_name}-%{_version}/openib.conf $RPM_BUILD_ROOT/%{IB_CONF_DIR}

%if %{build_libibverbs}
install -d $RPM_BUILD_ROOT/etc/ld.so.conf.d
echo %{_libdir} > $RPM_BUILD_ROOT/etc/ld.so.conf.d/ofed.conf
    %ifarch x86_64 ppc64
    echo %{_libdir32} >> $RPM_BUILD_ROOT/etc/ld.so.conf.d/ofed.conf
    %endif
%endif

%if %{build_libibverbs_utils}
install -d $RPM_BUILD_ROOT/etc/profile.d
cat > $RPM_BUILD_ROOT/etc/profile.d/ofed.sh << EOF
if ! echo \${PATH} | grep -q %{_prefix}/bin ; then
        PATH=\${PATH}:%{_prefix}/bin
fi
if ! echo \${PATH} | grep -q %{_prefix}/sbin ; then
        PATH=\${PATH}:%{_prefix}/sbin
fi
EOF
cat > $RPM_BUILD_ROOT/etc/profile.d/ofed.csh << EOF
if ( "\${path}" !~ *%{_prefix}/bin* ) then
        set path = ( \$path %{_prefix}/bin )
endif
if ( "\${path}" !~ *%{_prefix}/sbin* ) then
        set path = ( \$path %{_prefix}/sbin )
endif
EOF
%endif

%if %{build_dapl}
# udapl configuration file
perl -ni -e  "s@/usr/lib@%{_libdir}@;print" $RPM_BUILD_ROOT/%{_prefix}/etc/dat.conf
install -m 0644 $RPM_BUILD_ROOT/%{_prefix}/etc/dat.conf $RPM_BUILD_ROOT/etc/dat.conf
rm -f $RPM_BUILD_ROOT/%{_prefix}/etc/dat.conf
%endif

%if %{build_ipoib}
    install -d $RPM_BUILD_ROOT/%{NETWORK_CONF_DIR}
    DEVICES="ib0 ib1"
	
    for DEVICE in $DEVICES
    do
        if [ -f /etc/SuSE-release ]; then        
	
            echo BOOTPROTO=\'dhcp\'     >> $RPM_BUILD_ROOT/%{NETWORK_CONF_DIR}/ifcfg-${DEVICE}
            echo REMOTE_IPADDR=\'\'     >> $RPM_BUILD_ROOT/%{NETWORK_CONF_DIR}/ifcfg-${DEVICE}
            echo STARTMODE=\'onboot\'   >> $RPM_BUILD_ROOT/%{NETWORK_CONF_DIR}/ifcfg-${DEVICE}
            echo WIRELESS=\'no\'        >> $RPM_BUILD_ROOT/%{NETWORK_CONF_DIR}/ifcfg-${DEVICE}
	
        else
	
            echo DEVICE=${DEVICE}   >> $RPM_BUILD_ROOT/%{NETWORK_CONF_DIR}/ifcfg-${DEVICE}
            echo BOOTPROTO=dhcp     >> $RPM_BUILD_ROOT/%{NETWORK_CONF_DIR}/ifcfg-${DEVICE}
            echo ONBOOT=yes         >> $RPM_BUILD_ROOT/%{NETWORK_CONF_DIR}/ifcfg-${DEVICE}
	
        fi
    done
%endif

# Install openib service script
install -d $RPM_BUILD_ROOT/etc/init.d
install -m 0755 $RPM_BUILD_DIR/%{_name}-%{_version}/openibd $RPM_BUILD_ROOT/etc/init.d

%if %{build_opensm}
install -m 0644 $RPM_BUILD_DIR/%{_name}-%{_version}/opensm.conf $RPM_BUILD_ROOT/etc/opensm.conf
install -m 0755 $RPM_BUILD_DIR/%{_name}-%{_version}/opensmd $RPM_BUILD_ROOT/etc/init.d/opensmd

# Add sldd.sh (W/A for handover issue)

install -m 0755 $RPM_BUILD_DIR/%{_name}-%{_version}/sldd.sh $RPM_BUILD_ROOT/%{_prefix}/bin/sldd.sh
sed -i -e "s@/usr/bin/opensm@%{_prefix}/bin/opensm@g" $RPM_BUILD_ROOT/etc/init.d/opensmd
sed -i -e "s@/usr/bin/sldd.sh@%{_prefix}/bin/sldd.sh@g" $RPM_BUILD_ROOT/etc/init.d/opensmd
%endif

%if %{include_udev_rules}
install -d $RPM_BUILD_ROOT/etc/udev/rules.d
install -m 0644 $RPM_BUILD_DIR/%{_name}-%{_version}/90-ib.rules $RPM_BUILD_ROOT/etc/udev/rules.d
%endif
	
%clean
#Remove installed driver after rpm build finished
# Leave $RPM_BUILD_ROOT in order to build dependent packages
rm -rf $RPM_BUILD_DIR/%{_name}-%{_version}

###
### pre section
###

%pre -n kernel-ib
# Backup original infiniband kernel modules
# under 'prefix'/backup directory

if [ -d %{LIB_MOD_DIR} ]; then
    mkdir -p %{_prefix}/backup
    if [ ! -f %{_prefix}/backup/infiniband_ko-%{KVERSION}.tgz ]; then
        /bin/rm -f %{_prefix}/backup/infko_tmp.tgz
        tar czfP %{_prefix}/backup/infko_tmp.tgz %{LIB_MOD_DIR}
        mv %{_prefix}/backup/infko_tmp.tgz %{_prefix}/backup/infiniband_ko-%{KVERSION}.tgz
    fi
    /bin/rm -rf %{LIB_MOD_DIR}
fi
# END of pre -n kernel-ib


%pre -n kernel-ib-devel
## #########################################################################
## #               Backup Gen2 original sources and include files          #
## #########################################################################
## 
## if [ -d %{KERNEL_SOURCES}/drivers/infiniband ]; then
##  mkdir -p %{_prefix}/backup
##  if [ ! -f %{_prefix}/backup/infiniband-%{KVERSION}.tgz ]; then
##      /bin/rm -f %{_prefix}/backup/inf_tmp.tgz
##      tar czfP %{_prefix}/backup/inf_tmp.tgz %{KERNEL_SOURCES}/drivers/infiniband
##      mv %{_prefix}/backup/inf_tmp.tgz %{_prefix}/backup/infiniband-%{KVERSION}.tgz
##  fi
##  /bin/rm -rf %{KERNEL_SOURCES}/drivers/infiniband
## fi
## 
## %if %{include_rdma}
## # Backup original include/rdma directory and copy the new one
## if [ -d %{KERNEL_SOURCES}/include/rdma ]; then
##  mkdir -p %{_prefix}/backup
##  if [ ! -f %{_prefix}/backup/rdma-%{KVERSION}.tgz ]; then
##      /bin/rm -f %{_prefix}/backup/rdma_tmp.tgz
##      tar czfP %{_prefix}/backup/rdma_tmp.tgz %{KERNEL_SOURCES}/include/rdma
##      mv %{_prefix}/backup/rdma_tmp.tgz %{_prefix}/backup/rdma-%{KVERSION}.tgz
##  fi
##  /bin/rm -rf %{KERNEL_SOURCES}/include/rdma
##  mkdir -p %{KERNEL_SOURCES}/include
## fi
## %endif
## 
## %if %{include_srp_h}
## # Backup original scsi/srp.h file and copy the new one
## if [ -f %{KERNEL_SOURCES}/include/scsi/srp.h ]; then
##  mkdir -p %{_prefix}/backup
##  if [ ! -f %{_prefix}/backup/srp-%{KVERSION}.h ]; then
##   mv %{KERNEL_SOURCES}/include/scsi/srp.h %{_prefix}/backup/srp-%{KVERSION}.h
##  fi
##  mkdir -p %{KERNEL_SOURCES}/include/scsi
## fi
## %endif
## # END of pre -n kernel-ib-devel

#########################################################################
#                       Backup Done                                     #
#########################################################################

###
### post section
###

%post -n kernel-ib
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
count_ib_ports()
{
    local cnt=0
    local tmp_cnt=0
    
    tmp_cnt=$(/sbin/lspci -n | grep "15b3:6282" | wc -l | tr -d '[:space:]') # Arbel mode
    cnt=$[ $cnt + 2*${tmp_cnt} ]
    
    tmp_cnt=$(/sbin/lspci -n | grep -E "15b3:5e8c|15b3:6274" | wc -l | tr -d '[:space:]') # Sinai
    cnt=$[ $cnt + ${tmp_cnt} ]

    tmp_cnt=$(/sbin/lspci -n | grep -E "15b3:5a44|15b3:6278" | wc -l | tr -d '[:space:]') # Tavor mode
    cnt=$[ $cnt + 2*${tmp_cnt} ]
    
    return $cnt
}

count_ib_ports
ports_num=$?

# Set default number of ports to 2 if no HCAs found
if [ $ports_num -eq 0 ]; then
    ports_num=2
fi    
#############################################################################################################
#                                       Modules configuration                                               #
#############################################################################################################

# Update /etc/modprobe.conf
# Remove previous configuration if exist
perl -ni -e 'if (/\#\# BEGIN OpenIB \#\#$/) { $filter = 1 }' -e 'if (!$filter) { print }' -e 'if (/\#\# END OpenIB \#\#$/){ $filter = 0 }' /etc/modprobe.conf


%if ! %{include_udev_rules}
    if [ -e /etc/udev/udev.rules ]; then
        perl -ni -e 'if (/\# Infiniband devices \#$/) { $filter = 1 }' -e 'if (!$filter) { print }' -e 'if (/\# End Infiniband devices \#$/){ $filter = 0 }' /etc/udev/udev.rules
        cat >> /etc/udev/udev.rules << EOF
# Infiniband devices #
KERNEL="umad*", NAME="infiniband/%k"
KERNEL="issm*", NAME="infiniband/%k"
KERNEL="ucm*", NAME="infiniband/%k", MODE="0666"
KERNEL="uverbs*", NAME="infiniband/%k", MODE="0666"
KERNEL="uat", NAME="infiniband/%k", MODE="0666"
KERNEL="ucma", NAME="infiniband/%k", MODE="0666"
KERNEL="rdma_cm", NAME="infiniband/%k", MODE="0666"
# End Infiniband devices #
EOF
    fi
%endif

%if %{modprobe_update}
%if %{build_ipoib}
for (( i=0 ; i < $ports_num ; i++ ))
do
cat >> /etc/modprobe.conf << EOF
alias ib${i} ib_ipoib
EOF
done
%endif

%if %{build_sdp}
cat >> /etc/modprobe.conf << EOF
alias net-pf-27 ib_sdp
EOF
%endif
%endif
          
    /sbin/depmod -r -ae %{KVERSION}

#############################################################################################################


if [[ -f /etc/redhat-release || -f /etc/rocks-release ]]; then        
perl -i -ne 'if (m@^#!/bin/bash@) {
        print q@#!/bin/bash
#
# Bring up/down openib
#
# chkconfig: 2345 15 85
# description: Activates/Deactivates InfiniBand Driver to \
#              start at boot time.
#
### BEGIN INIT INFO
# Provides:       openibd
### END INIT INFO
@;
                 } else {
                     print;
                 }' /etc/init.d/openibd

        /sbin/chkconfig --del openibd 
        /sbin/chkconfig --add openibd 
fi

if [ -f /etc/SuSE-release ]; then
        perl -i -ne 'if (m@^#!/bin/bash@) {
        print q@#!/bin/bash
### BEGIN INIT INFO
# Provides:       openibd
# Required-Start: $local_fs $network
# Required-Stop: opensmd
# Default-Start:  2 3 5
# Default-Stop: 0 1 2 6
# Description:    Activates/Deactivates InfiniBand Driver to \
#                 start at boot time.
### END INIT INFO
@;
                 } else {
                     print;
                 }' /etc/init.d/openibd

        /sbin/insserv openibd
fi

%if %{build_kernel_ib}
    echo >> %{IB_CONF_DIR}/openib.conf
    echo "# Load UCM module" >> %{IB_CONF_DIR}/openib.conf
    echo "UCM_LOAD=no" >> %{IB_CONF_DIR}/openib.conf
    echo >> %{IB_CONF_DIR}/openib.conf
    echo "# Load RDMA_CM module" >> %{IB_CONF_DIR}/openib.conf
    echo "RDMA_CM_LOAD=yes" >> %{IB_CONF_DIR}/openib.conf
    echo >> %{IB_CONF_DIR}/openib.conf
    echo "# Load RDMA_UCM module" >> %{IB_CONF_DIR}/openib.conf
    echo "RDMA_UCM_LOAD=yes" >> %{IB_CONF_DIR}/openib.conf
    echo >> %{IB_CONF_DIR}/openib.conf
    echo "# Increase ib_mad thread priority" >> %{IB_CONF_DIR}/openib.conf
    echo "RENICE_IB_MAD=no" >> %{IB_CONF_DIR}/openib.conf
%endif

%if %{build_mthca}
       echo >> %{IB_CONF_DIR}/openib.conf                                                
       echo "# Load MTHCA" >> %{IB_CONF_DIR}/openib.conf
       echo "MTHCA_LOAD=yes" >> %{IB_CONF_DIR}/openib.conf
%endif

%if %{build_ipath}
       echo >> %{IB_CONF_DIR}/openib.conf                                                
       echo "# Load IPATH" >> %{IB_CONF_DIR}/openib.conf
       echo "IPATH_LOAD=yes" >> %{IB_CONF_DIR}/openib.conf
%endif

%if %{build_ehca}
       echo >> %{IB_CONF_DIR}/openib.conf                                                
       echo "# Load eHCA" >> %{IB_CONF_DIR}/openib.conf
       echo "EHCA_LOAD=yes" >> %{IB_CONF_DIR}/openib.conf
%endif

%if %{build_ipoib}
       echo >> %{IB_CONF_DIR}/openib.conf                                                
       echo "# Load IPoIB" >> %{IB_CONF_DIR}/openib.conf
       echo "IPOIB_LOAD=yes" >> %{IB_CONF_DIR}/openib.conf
%endif

%if %{build_sdp}
       echo >> %{IB_CONF_DIR}/openib.conf                                                
       echo "# Load SDP module" >> %{IB_CONF_DIR}/openib.conf
       echo "SDP_LOAD=no" >> %{IB_CONF_DIR}/openib.conf
%endif

%if %{build_srp}
       echo >> %{IB_CONF_DIR}/openib.conf                                                
       echo "# Load SRP module" >> %{IB_CONF_DIR}/openib.conf
       echo "SRP_LOAD=no" >> %{IB_CONF_DIR}/openib.conf
%endif

%if %{build_iser}
       echo >> %{IB_CONF_DIR}/openib.conf                                                
       echo "# Load ISER module" >> %{IB_CONF_DIR}/openib.conf
       echo "ISER_LOAD=no" >> %{IB_CONF_DIR}/openib.conf
%endif

%if %{build_rds}
       echo >> %{IB_CONF_DIR}/openib.conf                                                
       echo "# Load RDS module" >> %{IB_CONF_DIR}/openib.conf
       echo "RDS_LOAD=no" >> %{IB_CONF_DIR}/openib.conf
%endif

fi # 1 : closed
# END of post -n kernel-ib

%post -n kernel-ib-devel
# if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
#     cd %{_prefix}/src/
#     ln -snf %{_name}-%{_version} %{_name}
# fi # 1 : closed
# END of post -n kernel-ib-devel

%post -n libibverbs
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
    /sbin/ldconfig
fi

%post -n libibverbs-devel
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
    /sbin/ldconfig
fi

%post -n libibverbs-utils
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
    /sbin/ldconfig
fi

%post -n libibcm
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
    /sbin/ldconfig
fi

%post -n libmthca
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
    /sbin/ldconfig
fi

%post -n libmthca-devel
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
    /sbin/ldconfig
fi

%post -n libehca
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
    /sbin/ldconfig
fi

%post -n libehca-devel
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
    /sbin/ldconfig
fi

%post -n libipathverbs
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
    /sbin/ldconfig
fi

%post -n libipathverbs-devel
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
    /sbin/ldconfig
fi

%post -n libsdp
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
    /sbin/ldconfig
fi

%post -n libibcommon
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
    /sbin/ldconfig
fi

%post -n libibcommon-devel
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
    /sbin/ldconfig
fi

%post -n libibmad
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
    /sbin/ldconfig
fi

%post -n libibmad-devel
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
    /sbin/ldconfig
fi

%post -n libibumad
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
    /sbin/ldconfig
fi

%post -n libibumad-devel
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
    /sbin/ldconfig
fi

%post -n libosmcomp
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
    /sbin/ldconfig
fi

%post -n libosmcomp-devel
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
    /sbin/ldconfig
fi

%post -n libosmvendor
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
    /sbin/ldconfig
fi

%post -n libosmvendor-devel
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
    /sbin/ldconfig
fi

%post -n libopensm
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
    /sbin/ldconfig
fi


%post -n ipoibtools
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
    if [ -e %{IB_CONF_DIR}/openib.conf ]; then
       echo >> %{IB_CONF_DIR}/openib.conf                                                
       echo "# Enable IPoIB High Availability daemon" >> %{IB_CONF_DIR}/openib.conf
       echo "IPOIBHA_ENABLE=no" >> %{IB_CONF_DIR}/openib.conf
       echo "# PRIMARY_IPOIB_DEV=ib0" >> %{IB_CONF_DIR}/openib.conf
       echo "# SECONDARY_IPOIB_DEV=ib1" >> %{IB_CONF_DIR}/openib.conf
    fi
fi

%post -n srptools
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
    if [ -e %{IB_CONF_DIR}/openib.conf ]; then
       echo >> %{IB_CONF_DIR}/openib.conf                                                
       echo "# Enable SRP High Availability daemon" >> %{IB_CONF_DIR}/openib.conf
       echo "SRPHA_ENABLE=no" >> %{IB_CONF_DIR}/openib.conf
    fi
fi

%post -n libopensm-devel
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
    /sbin/ldconfig
fi

%post -n opensm
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
if [[ -f /etc/redhat-release || -f /etc/rocks-release ]]; then
        perl -i -ne 'if (m@^#!/bin/bash@) {
        print q@#!/bin/bash
#
# Bring up/down opensm
#
# chkconfig: 235 40 80
# description: Activates/Deactivates all OpenSM to \
#              start at boot time.
#
### BEGIN INIT INFO
# Provides:       opensmd
### END INIT INFO
@;
                 } else {
                     print;
                 }' /etc/init.d/opensmd

        /sbin/chkconfig --del opensmd
        /sbin/chkconfig --add opensmd
fi

if [ -f /etc/SuSE-release ]; then
        perl -i -ne 'if (m@^#!/bin/bash@) {
        print q@#!/bin/bash
### BEGIN INIT INFO
# Provides:       opensmd
# Required-Start: $network openibd
# Required-Stop:
# Default-Start:  2 3 5
# Default-Stop: 0 1 2 6
# Description:    Activates/Deactivates OpenSM to \
#                 start at boot time.
### END INIT INFO
@;
                 } else {
                     print;
                 }' /etc/init.d/opensmd

        /sbin/insserv opensmd
fi

fi # 1 : Closed

%post -n librdmacm
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
    /sbin/ldconfig
fi

%post -n dapl
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
    /sbin/ldconfig
fi

%post -n dapl-devel
if [ $1 = 1 ]; then # 1 : This package is being installed for the first time
    /sbin/ldconfig
fi

###
### preun section
###

%preun -n kernel-ib
if [ $1 = 0 ]; then  # 1 : Erase, not upgrade
          if [[ -f /etc/redhat-release || -f /etc/rocks-release ]]; then        
               /sbin/chkconfig --del openibd 
          fi
          if [ -f /etc/SuSE-release ]; then
               /sbin/insserv -r openibd
          fi
fi

%preun -n opensm
if [ $1 = 0 ]; then  # 1 : Erase, not upgrade
    if [[ -f /etc/redhat-release || -f /etc/rocks-release ]]; then
         /sbin/chkconfig --del opensmd
    fi
    if [ -f /etc/SuSE-release ]; then
         /sbin/insserv -r opensmd
    fi
fi

###
### post uninstall section
###
%postun -n kernel-ib
if [ $1 = 0 ]; then  # 1 : Erase, not upgrade
    if [ -f %{_prefix}/backup/infiniband_ko-%{KVERSION}.tgz ]; then
        /bin/rm -rf %{LIB_MOD_DIR}
        tar xzfP %{_prefix}/backup/infiniband_ko-%{KVERSION}.tgz
        /bin/rm -f %{_prefix}/backup/infiniband_ko-%{KVERSION}.tgz
        /sbin/depmod -r -ae %{KVERSION}
    fi
    
    if [ `uname -r | cut -c -3` == "2.6" ]; then
        # Clean /etc/modprobe.conf   
        # Remove previous configuration if exist
        perl -ni -e "print unless (/ib_ipoib/)" /etc/modprobe.conf
        perl -ni -e "print unless (/ib_sdp/)" /etc/modprobe.conf
        perl -ni -e 'if (/\#\# BEGIN OpenIB \#\#$/) { $filter = 1 }' -e 'if (!$filter) { print }' -e 'if (/\#\# END OpenIB \#\#$/){ $filter = 0 }' /etc/modprobe.conf
        /sbin/depmod -r -ae %{KVERSION}

# Clean udev.rules
%if ! %{include_udev_rules}
    if [ -e /etc/udev/udev.rules ]; then
        perl -ni -e 'if (/\# Infiniband devices \#$/) { $filter = 1 }' -e 'if (!$filter) { print }' -e 'if (/\# End Infiniband devices \#$/){ $filter = 0 }' /etc/udev/udev.rules
    fi
%endif

    fi
fi

%postun -n kernel-ib-devel
# if [ $1 = 0 ]; then  # 1 : Erase, not upgrade
#     cd %{_prefix}/src/
#     rm -f %{_name}
# fi

%postun -n libibverbs
if [ $1 = 0 ]; then  # 1 : Erase, not upgrade
    /sbin/ldconfig        
fi



###
### Files
###
%if %{build_kernel_ib}
%files -n kernel-ib
%defattr(-,root,root,-)
%dir %{LIB_MOD_DIR}
%{LIB_MOD_DIR}/core
%if %{build_mthca}
%{LIB_MOD_DIR}/hw/mthca
%endif
%if %{build_ipath}
%{LIB_MOD_DIR}/hw/ipath
%endif
%if %{build_ehca}
%{LIB_MOD_DIR}/hw/ehca
%endif
%if %{MEMTRACK}
%{LIB_MOD_DIR}/debug/memtrack.ko
%endif
%if %{MADEYE}
%{LIB_MOD_DIR}/util/ib_madeye.ko
%endif
%if %{build_ipoib} && %{include_ipoib_conf}
%dir %{NETWORK_CONF_DIR}
%config(noreplace) %{NETWORK_CONF_DIR}/ifcfg-ib*[0-9]
%endif
%dir %{IB_CONF_DIR}
%config(noreplace) %{IB_CONF_DIR}/openib.conf
%{IB_CONF_DIR}/info
/etc/init.d/openibd
%if %{include_udev_rules}
/etc/udev/rules.d/90-ib.rules
%endif
%if %{build_ipoib}
%{LIB_MOD_DIR}/ulp/ipoib
%endif
%if %{build_sdp}
%{LIB_MOD_DIR}/ulp/sdp
%endif
%if %{build_srp}
%{LIB_MOD_DIR}/ulp/srp
%endif
%if %{build_iser}
%{LIB_MOD_DIR}/ulp/iser
%endif
%if %{build_rds}
%{LIB_MOD_DIR}/ulp/rds
%endif

%endif

%if %{build_kernel_ib_devel}
%files -n kernel-ib-devel
%defattr(-,root,root,-)
## %dir %{KERNEL_SOURCES}/drivers/infiniband
## # %{KERNEL_SOURCES}/drivers/infiniband/include
## %{KERNEL_SOURCES}/drivers/infiniband/core
## %{KERNEL_SOURCES}/drivers/infiniband/hw
## %{KERNEL_SOURCES}/drivers/infiniband/Makefile
## %{KERNEL_SOURCES}/drivers/infiniband/Kconfig
## %if %{include_rdma}
## %{KERNEL_SOURCES}/include/rdma
## %endif
## %{KERNEL_SOURCES}/drivers/infiniband/ulp/ipoib
## %{KERNEL_SOURCES}/drivers/infiniband/ulp/sdp
## %{KERNEL_SOURCES}/drivers/infiniband/ulp/srp
## %if %{include_srp_h}
## %{KERNEL_SOURCES}/include/scsi/srp.h
## %endif
%dir %{_prefix}/src
%{_prefix}/src/%{_name}-%{_version}
%{_prefix}/src/%{_name}
%endif

%if %{build_libibverbs}
%files -n libibverbs -f libibverbs-files
%defattr(-,root,root,-)
%{_libdir}/libibverbs*.so.*
/etc/ld.so.conf.d/ofed.conf
%endif

%if %{build_libibverbs_devel}
%files -n libibverbs-devel -f libibverbs-devel-files
%defattr(-,root,root,-)
%{_libdir}/libibverbs*.a
%{_libdir}/libibverbs*.so
%{_prefix}/include/infiniband/arch.h         
%{_prefix}/include/infiniband/driver.h       
%{_prefix}/include/infiniband/kern-abi.h     
%{_prefix}/include/infiniband/marshall.h     
%{_prefix}/include/infiniband/opcode.h       
%{_prefix}/include/infiniband/sa.h           
%{_prefix}/include/infiniband/sa-kern-abi.h  
%{_prefix}/include/infiniband/verbs.h
#%{_includedir}/*
%endif

%if %{build_libibverbs_utils}
%files -n libibverbs-utils
%defattr(-,root,root,-)
# %{_bindir}/*
%{_prefix}/bin/ibv_*
%{_prefix}/man/man1/ibv_*
/etc/profile.d/ofed.sh
/etc/profile.d/ofed.csh
%endif

%if %{build_libibcm}
%files -n libibcm -f libibcm-files
%defattr(-,root,root,-)
%{_libdir}/libibcm*.so.*
%endif

%if %{build_libibcm_devel}
%files -n libibcm-devel -f libibcm-devel-files
%defattr(-,root,root,-)
%{_libdir}/libibcm*.so
%{_prefix}/include/infiniband/cm_abi.h
%{_prefix}/include/infiniband/cm.h
%endif

%if %{build_libmthca}
%files -n libmthca -f libmthca-files
%defattr(-,root,root,-)
%{_libdir}/infiniband/mthca.so
# %doc AUTHORS COPYING ChangeLog README
%endif

%if %{build_libmthca_devel}
%files -n libmthca-devel -f libmthca-devel-files
%defattr(-,root,root,-)
%{_libdir}/infiniband/mthca.a
%endif

%if %{build_libipathverbs}
%files -n libipathverbs -f libipathverbs-files
%defattr(-,root,root,-)
%{_libdir}/infiniband/ipathverbs.so
# %doc AUTHORS COPYING ChangeLog README
%endif

%if %{build_libipathverbs_devel}
%files -n libipathverbs-devel -f libipathverbs-devel-files
%defattr(-,root,root,-)
%{_libdir}/infiniband/ipathverbs.a
%endif

%if %{build_libehca}
%files -n libehca -f libehca-files
%defattr(-,root,root,-)
%{_libdir}/infiniband/libehca*.so*
# %doc AUTHORS COPYING ChangeLog README
%endif

%if %{build_libehca_devel}
%files -n libehca-devel -f libehca-devel-files
%defattr(-,root,root,-)
%{_libdir}/infiniband/libehca*.a
%endif

%if %{build_libsdp}
%files -n libsdp -f libsdp-files
%defattr(-,root,root)
%{_libdir}/libsdp*.so*
#%config(noreplace) %{_sysconfdir}/libsdp.conf
%config(noreplace) %{_prefix}/etc/libsdp.conf
%endif

%if %{build_srptools}
%files -n srptools
%defattr(-,root,root)
%{_prefix}/sbin/ibsrpdm
%{_prefix}/sbin/srp_daemon
%{_prefix}/sbin/srp_daemon.sh
%{_prefix}/sbin/run_srp_daemon
%{_prefix}/man/man1/ibsrpdm.1* 
%{_prefix}/man/man1/srp_daemon.1*
%endif

%if %{build_ipoibtools}
%files -n ipoibtools
%defattr(-,root,root)
%{_prefix}/bin/arpingib
%{_prefix}/bin/mcasthandle
%{_prefix}/bin/ipoib_ha.pl
%{_prefix}/utils/ip
%endif

%if %{build_tvflash}
%files -n tvflash
%defattr(-,root,root)
%{_prefix}/sbin/tvflash
%endif

%if %{build_libibcommon}
%files -n libibcommon -f libibcommon-files
%defattr(-,root,root)
%{_libdir}/libibcommon*.so.*
%endif

%if %{build_libibcommon_devel}
%files -n libibcommon-devel -f libibcommon-devel-files
%defattr(-,root,root)
%{_libdir}/libibcommon.a
%{_libdir}/libibcommon*.so
%{_prefix}/include/infiniband/common.h
%endif

%if %{build_libibmad}                     
%files -n libibmad -f libibmad-files
%defattr(-,root,root)
%{_libdir}/libibmad*.so.*
%endif

%if %{build_libibmad_devel}
%files -n libibmad-devel -f libibmad-devel-files
%defattr(-,root,root)
%{_libdir}/libibmad.a
%{_libdir}/libibmad.so
%{_prefix}/include/infiniband/mad.h
%endif

%if %{build_libibumad}                
%files -n libibumad -f libibumad-files
%defattr(-,root,root)
%{_libdir}/libibumad*.so.*
%endif

%if %{build_libibumad_devel}
%files -n libibumad-devel -f libibumad-devel-files
%defattr(-,root,root)
%{_libdir}/libibumad.so
%{_libdir}/libibumad.a
%{_prefix}/include/infiniband/umad.h
%endif

%if %{build_diags}
%files -n openib-diags
%defattr(-,root,root)
%{_prefix}/bin/ibaddr 
%{_prefix}/bin/ibnetdiscover 
%{_prefix}/bin/ibping 
%{_prefix}/bin/ibroute 
%{_prefix}/bin/ibstat 
%{_prefix}/bin/ibsysstat 
%{_prefix}/bin/ibtracert 
%{_prefix}/bin/perfquery 
%{_prefix}/bin/sminfo 
%{_prefix}/bin/smpquery 
%{_prefix}/bin/saquery 
%{_prefix}/bin/smpdump
%{_prefix}/bin/ibchecknet
%{_prefix}/bin/ibchecknode
%{_prefix}/bin/ibcheckerrors
%{_prefix}/bin/ibcheckport
%{_prefix}/bin/ibhosts
%{_prefix}/bin/ibstatus 
%{_prefix}/bin/ibswitches
%{_prefix}/bin/ibdiscover.pl
%{_prefix}/bin/dump_lfts.sh
%{_prefix}/bin/ibcheckerrs
%{_prefix}/bin/ibcheckportstate
%{_prefix}/bin/ibcheckportwidth
%{_prefix}/bin/ibcheckstate
%{_prefix}/bin/ibcheckwidth
%{_prefix}/bin/ibclearcounters
%{_prefix}/bin/ibclearerrors
%{_prefix}/bin/ibnodes
%{_prefix}/bin/ibportstate
%{_prefix}/man/man8/ib*
%{_prefix}/man/man8/sm*
%{_prefix}/man/man8/dump_lfts*
%endif

%if %{build_libosmcomp}
%files -n libosmcomp -f libosmcomp-files
%defattr(-,root,root)
%{_libdir}/libosmcomp*.so.*
%endif

%if %{build_libosmcomp_devel}
%files -n libosmcomp-devel -f libosmcomp-devel-files
%defattr(-,root,root)
%{_libdir}/libosmcomp*.so
%{_libdir}/libosmcomp*.a
%{_prefix}/include/infiniband/complib
%endif

%if %{build_libosmvendor}
%files -n libosmvendor -f libosmvendor-files
%defattr(-,root,root)
%{_libdir}/libosmvendor*.so.*
%endif

%if %{build_libosmvendor_devel}
%files -n libosmvendor-devel -f libosmvendor-devel-files
%defattr(-,root,root)
%{_libdir}/libosmvendor*.so
%{_libdir}/libosmvendor*.a
%{_prefix}/include/infiniband/vendor
%endif

%if %{build_libopensm}
%files -n libopensm -f libopensm-files
%defattr(-,root,root)
%{_libdir}/libopensm*.so.*
%endif

%if %{build_libopensm_devel}
%files -n libopensm-devel -f libopensm-devel-files
%defattr(-,root,root)
%{_libdir}/libopensm*.so
%{_libdir}/libopensm*.a
%{_prefix}/include/infiniband/opensm
%{_prefix}/include/infiniband/iba
%endif

%if %{build_opensm}
%files -n opensm
%defattr(-,root,root)
%{_prefix}/bin/opensm
%{_prefix}/bin/osmtest
%{_prefix}/bin/sldd.sh
%config(noreplace) /etc/opensm.conf
/etc/init.d/opensmd
%{_prefix}/man/man8/opensm*
%{_prefix}/man/man8/osmtest*
%endif

%if %{build_perftest}
%files -n perftest
%defattr(-,root,root)
%{_prefix}/bin/ib_rdma_lat
%{_prefix}/bin/ib_rdma_bw
%{_prefix}/bin/ib_write_lat
%{_prefix}/bin/ib_write_bw
%{_prefix}/bin/ib_send_lat
%{_prefix}/bin/ib_send_bw
%{_prefix}/bin/ib_read_lat
%{_prefix}/bin/ib_read_bw
%{_prefix}/bin/runme
%{_prefix}/bin/ib_write_bw_postlist
%{_prefix}/bin/ib_clock_test
%endif

%if %{build_mstflint}
%files -n mstflint
%defattr(-,root,root)
%{_prefix}/bin/mread
%{_prefix}/bin/mwrite
%{_prefix}/bin/mstflint
%endif

%if %{build_librdmacm}
%files -n librdmacm -f librdmacm-files
%defattr(-,root,root)
%{_libdir}/librdmacm*.so.*
%endif

%if %{build_librdmacm_devel}
%files -n librdmacm-devel -f librdmacm-devel-files
%defattr(-,root,root)
%{_libdir}/librdmacm*.so
%{_prefix}/include/rdma/rdma_cma_abi.h
%{_prefix}/include/rdma/rdma_cma.h
%endif

%if %{build_librdmacm_utils}
%files -n librdmacm-utils
%defattr(-,root,root)
%{_prefix}/bin/rping
%{_prefix}/bin/ucmatose
# %{_prefix}/bin/udaddy
# %{_prefix}/bin/mckey
%endif

%if %{build_dapl}
%files -n dapl -f dapl-files
%defattr(-,root,root)
%{_libdir}/libda*.so.*
%config(noreplace) %{_sysconfdir}/dat.conf
%endif

%if %{build_dapl_devel}
%files -n dapl-devel -f dapl-devel-files
%defattr(-,root,root)
%{_libdir}/libda*.so
%{_libdir}/libda*.a
%{_prefix}/include/dat/dat.h
%{_prefix}/include/dat/dat_error.h
%{_prefix}/include/dat/dat_platform_specific.h
%{_prefix}/include/dat/dat_redirection.h
%{_prefix}/include/dat/dat_registry.h
%{_prefix}/include/dat/dat_vendor_specific.h
%{_prefix}/include/dat/udat_config.h
%{_prefix}/include/dat/udat.h
%{_prefix}/include/dat/udat_redirection.h
%{_prefix}/include/dat/udat_vendor_specific.h
%endif
# END Files

%changelog
* Thu Aug 24 2006 Vladimir Sokolovsky <vlad@mellanox.co.il>
- Added ehca driver and libehca library
* Tue Aug 15 2006 Vladimir Sokolovsky <vlad@mellanox.co.il>
- Added libopensm, libosmcom and libosmvendor packages
* Thu May 18 2006 Vladimir Sokolovsky <vlad@mellanox.co.il>
- Added libibcm-devel, librdmacm-devel and librdmacm-utils packages
* Tue May 16 2006 Vladimir Sokolovsky <vlad@mellanox.co.il>
- Removed links from /usr/bin to 'prifix'/bin
* Sun May 14 2006 Vladimir Sokolovsky <vlad@mellanox.co.il>
- Removed ibutils
* Wed Apr  27 2006 Vladimir Sokolovsky <vlad@mellanox.co.il>
- Removed libibat
* Wed Apr  5 2006 Vladimir Sokolovsky <vlad@mellanox.co.il>
- Added dapl and dapl-devel packages
* Sun Apr  2 2006 Vladimir Sokolovsky <vlad@mellanox.co.il>
- Changed ibdiag to ibutils. Added ibis, ibdm and ibmgtsim packages
* Thu Mar 23 2006 Vladimir Sokolovsky <vlad@mellanox.co.il>
- Added libibcommon-devel, libibmad-devel and libibumad-devel packages
* Tue Mar 14 2006 Vladimir Sokolovsky <vlad@mellanox.co.il>
- Added ibdiag tools
* Mon Mar 13 2006 Vladimir Sokolovsky <vlad@mellanox.co.il>
- Changed osm to opensm, added opensm-devel package
* Wed Mar  8 2006 Vladimir Sokolovsky <vlad@mellanox.co.il>
- Added header files: include/infiniband/...
* Sun Mar  5 2006 Vladimir Sokolovsky <vlad@mellanox.co.il>
- Repackaging: openib like RPMs
* Mon Jan  2 2006 Vladimir Sokolovsky <vlad@mellanox.co.il>
- Added libsdp 32 bit libraries for x86_64 platform
* Mon Nov 14 2005 Vladimir Sokolovsky <vlad@mellanox.co.il>
- Initial packaging for openib gen2 stack
